
'email.bas - Sample escript to demonstrate sending email from AniTa
'
'  email.bas
'  e-script for AniTa
'  requires minimum: AniTa 9,
'  and a 32-bit command line email SMTP client.  For example 32-bit "blat"
' (blat is a free email client that can be downloaded from Internet or from our download ftp server )
'
' Put an email dialog on screen when user clicks on an email address.
' Send email using 3rd party command line smtp client.
' Can be called with destination "to" email parameter like: email.bas>MainTo>name@domain.com 
' Or plain: email.bas
'
' Will do the following:
'
' Open a dialog to let the user enter email items like: to, from, subject and text body.
' Do some very basic validation
' Call AniTa AniMacro API to get the message sent executing %run% macro to start blat.exe .......

' To configure and test, do the following:
' - In AniTa Dynamic Hotspot settings:
' - Check "Enable Dynamic Links"
' - For @ in "Text to display as a hotspot", check "Link (Web or Email)
' - Set Click action to: %escript%email.bas>MainTo>
' - Save it
' - Put the email.bas script in the [path] folder (./email.bas if in local AniTa folder)
' - Put the blat.exe also in the [path] folder (./blat.exe if in local AniTa folder)
'   In 64-bit Windows systems possibly put blat.exe in C:\WINDOWS\SysWOW64
' - Click on screen where an email address is displayed and see the email.bas dialog open

' Note:
' blat.exe is is a command line smtp email client capable of sending email in many ways
' and with a myriad of options.  This demo only exercise the most simple way to send email.
' the smtp server is assumed to be fixed and therefor not set on command line.
' To set a default smtp server:  
' In admin mode, run the 
' blat -install command.  Like this:
' blat -install <smtpserver>
' Or change email.bas to supply it in every call: -server <smtpserver>
'
' 
' Tip:
' First run this script without click activation by screen email address. 
' For example, map some keyboard key or hotspot to %escript%email.bas just
' to make sure the script can be found.
' Open a command window and run the blat command directly without AniTa involved
' For example: blat -log somefile.log -debug -to to@domain.com -from me@domain.com -subject testing - body "this is my body"
' Use the macro %runwait% instead of %runhidewait% to see the command window open when blat.exe is executed.

'Written by:
'Bjorn Karlsson, April System Design, April 28 2019
'Copyright: This is a demo program that can be used and modified for free by AniTa licensed users


Dim to_x as string

Sub Main

Begin Dialog DLGEMAIL 27,6, 244, 176, "Email Client Dialog"		', .DlgFunction
  TextBox 44,4,156,12, .EditBox_To
  TextBox 44,20,156,12, .EditBox_From
  TextBox 44,40,156,12, .EditBox_Subject
  TextBox 44,56,156,108, .EditBox_Body
  Text 4,56,37,12, "Message"
  Text 4,40,32,8, "Subject"
  Text 8,20,32,8, "From"
  Text 8,4,32,8, "To"
  OKButton 204,144,28,16
  CancelButton 204,104,28,16
End Dialog

Dim valid As Integer
Dim command As String

Dim Dlg1 As DLGEMAIL
Dlg1.EditBox_To = to_x
Dlg1.EditBox_From = "support@bullcityfinancial.com"
Dlg1.EditBox_Subject = "Email to Client"


Button = Dialog (Dlg1)
valid = 1

If Button = -1 Then	' -1 means OK button
' for debug:
'MsgBox Dlg1.EditBox_Body
'MsgBox Dlg1.EditBox_Subject
'MsgBox Dlg1.EditBox_To
'MsgBox Dlg1.EditBox_From
 xxx = 1

 If Dlg1.EditBox_To = "" Then
 MsgBox "Destination missing or invalid!" + Dlg1.EditBox_To
 valid = 0
 End If
 If Dlg1.EditBox_Subject = "" Then
 MsgBox "Subject missing or invalid" + Dlg1.EditBox_Subject
 valid = 0
 End If 
 If Dlg1.EditBox_Body = "" Then
 MsgBox "Message body missing or invalid!" + Dlg1.EditBox_Body
 valid = 0
 End If

If valid = 1 Then
' Note: option -log email.log will append all conversations.  Remove it from command or remove the log file daily
command = "%runhidewait%C:\\bullcity\\Anita\\Scripts\\blat -server smtp.emailsrvr.com:2525 -u support@bullcityfinancial.com -pw 19walston75 -log email.log -debug -f """ + Dlg1.EditBox_From + """"  + " -to """ + Dlg1.EditBox_To + """"  + " -subject """ + Dlg1.EditBox_Subject + """ -body " + """" + Dlg1.EditBox_Body + """"

AniMacro (command)
MsgBox "Email Sent"
Else
 MsgBox "Input validation failed!"
End If

End If

End Sub

' Enter here if called with parameter like: email.bas>MainTo>someone@company.com
Function MainTo(p_to As String) As String
to_x = p_to
Main
End Function

